﻿namespace Code6587EN.Ch05.RevertPage
{
    using Microsoft.SharePoint;
    using Microsoft.SharePoint.Administration;
    using Microsoft.SharePoint.Publishing;
    using System;
    using System.Linq;

    /// <summary>
    /// Console Application to Revert a Publishing Page
    /// </summary>
    class Program
    {
        static void Main(string[] args)
        {
            // Open the Site Collection containing the Site
            using (var site = new SPSite("http://sharepoint/publishing"))
            {
                // Open the Site
                using (var web = site.OpenWeb())
                {
                    // Get the Publishing Site from the SharePoint Site
                    var pubWeb = PublishingWeb.GetPublishingWeb(web);

                    // Create a CAML query to get the Page by its Title
                    var camlQuery = "<Where><Eq><FieldRef Name='Title'></FieldRef><Value Type='Text'>Code Page</Value></Eq></Where>";

                    // Get the Page with the CAML query
                    var page = pubWeb.GetPublishingPages(camlQuery).First();

                    // Check out the Page
                    page.ListItem.File.CheckOut();

                    // Revert the Page
                    page.ListItem.Versions.RestoreByLabel("1.0");
                    
                    // Check in the Page
                    page.ListItem.File.CheckIn("Reverted to Version 1.0");
                }
            }

            // Wait for a key to be pressed before closing the application
            Console.WriteLine("Press Any Key to Continue...");
            Console.Read();
        }
    }
}
